"""
This algorithm will decide whether a graph is bipartite or not.
"""

n = int(input())
m = int(input())
#This array of arrays will have at place i an array with the neigbours of vertex i
rel = [set() for i in range(0,n+1)]

#This colorArr will bookkeep the colors of vertices.
#For vertex i, colorArr[i] will be -1 if it has not been assigned a color yet
# colorArr[i] will be either 1 or 0, whether it has the first or second color
colorArr = [-1]*(n+1)
colorArr[1] = 1 #Give vertex 1 the color 1
queue = []
queue.append(1) #This set will bookkeep all vertices whose neigbours we still have to consider
bipartite = True #Assume it is bipartite. When not, we will put it to false
finished = False

for i in range(0,m): #For all relations in the graph
    a,b = input().split()
    rel[int(a)].add(int(b))
    rel[int(b)].add(int(a))

while not finished and bipartite:
    while queue:
        u = queue.pop()

        #If there is an edge from u to u in the graph, it is not bipartite
        if u in rel[u]:
            bipartite = False;

        #Consider all vertices v that are connected to u
        for v in rel[u]:
            #If this neighbour does not yet have a color
            if colorArr[v] == -1:
                #Give it the color opposite to its neighbour
                colorArr[v] = 1 - colorArr[u]
                #Add to the queue, so that we don't forget to consider its neighbours
                queue.append(v)

            #If v and u have the same color, the graph is not bipartite
            elif colorArr[v] == colorArr[u]:
                bipartite = False
        
        #The following part will determine whether we have given each vertex a color yet
        finished = True
        index = 0
        for i in range(1,n+1):
            if colorArr[i] == -1:
                index = i
                finished = False
               
        #If there is a vertex uncoloured, but the queue is empty, our graph is disconnected
        #But we still want to check if all parts are bipartite
        if not finished and len(queue) == 0:
            queue.append(i)
            
        
if bipartite: #Graph bipartite iff eigenvalues symmetric
    print("1")
else:
    print("0")